/*
 * tkimgDecls.h --
 *
 *  Declarations of functions in the platform independent public TKIMG API.
 *
 */

#ifndef _TKIMGDECLS
#define _TKIMGDECLS

/*
 * WARNING: The contents of this file is automatically generated by the
 * genStubs.tcl script. Any modifications to the function declarations
 * below should be made in the tkimg.decls script.
 */

#include <tk.h>

#ifdef TKIMGAPI
#   undef TCL_STORAGE_CLASS
#   define TCL_STORAGE_CLASS DLLEXPORT
#else
#   define TKIMGAPI extern
#   undef USE_TKIMG_STUBS
#   define USE_TKIMG_STUBS 1
#endif

/* Check, if Tcl version supports Tcl_Size,
   which was introduced in Tcl 8.7 and 9.
*/
#ifndef TCL_SIZE_MAX
    #include <limits.h>
    #define TCL_SIZE_MAX INT_MAX

    #define TCL_SIZE_MODIFIER ""
    #define Tcl_GetSizeIntFromObj Tcl_GetIntFromObj
#endif

EXTERN int Tkimg_Init(Tcl_Interp *interp);
EXTERN int Tkimg_SafeInit(Tcl_Interp *interp);

/* Using a read buffer for RLE compressed files is appr. 2 times
 * faster than parsing without the buffer.
 * Larger sizes for the buffer make no substantial difference.
 * Note, that the read buffer only works and is needed when
 * reading from a channel (state == IMG_CHAN).
 */
#define READBUFLEN 512
typedef struct tkimg_FileReadBuffer {
    int useReadBuf;
    int bufStart;
    int bufEnd;
    char *readBuf;
} tkimg_FileReadBuffer;

typedef struct tkimg_Stream {
    Tcl_Channel channel; /* Channel identifier for state == IMG_CHAN */
    Tcl_Obj *byteObj;    /* ByteArray object for state == IMG_STRING */
    unsigned char *data; /* Pointer to ByteArray content. */
    int state;           /* Stream state: IMG_CHAN or IMG_STRING */
    Tcl_Size position;
    Tcl_Size length;     /* length of physical line already written */
    tkimg_FileReadBuffer readBuffer;
} tkimg_Stream;

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations:
 */

/* 0 */
TKIMGAPI Tcl_Channel	tkimg_OpenFileChannel(Tcl_Interp *interp,
				const char *fileName, const char *mode);
/* 1 */
TKIMGAPI void		tkimg_ReadInitFile(tkimg_Stream *handle,
				Tcl_Channel chan);
/* 2 */
TKIMGAPI int		tkimg_ReadInitString(tkimg_Stream *handle,
				Tcl_Obj *data);
/* 3 */
TKIMGAPI void		tkimg_WriteInitFile(tkimg_Stream *handle,
				Tcl_Channel chan);
/* 4 */
TKIMGAPI void		tkimg_WriteInitString(tkimg_Stream *handle);
/* 5 */
TKIMGAPI void		tkimg_EnableReadBuffer(tkimg_Stream *handle,
				int onOff);
/* 6 */
TKIMGAPI Tcl_Size	tkimg_Read(tkimg_Stream *handle, char *dst,
				Tcl_Size count);
/* 7 */
TKIMGAPI Tcl_Size	tkimg_Write(tkimg_Stream *handle, const char *src,
				Tcl_Size count);
/* 8 */
TKIMGAPI int		tkimg_Putc(tkimg_Stream *handle, int c);
/* 9 */
TKIMGAPI void		tkimg_GetTemporaryFileName(Tcl_DString *fileName);
/* 10 */
TKIMGAPI void		tkimg_DeleteFile(const char *fileName);
/* Slot 11 is reserved */
/* Slot 12 is reserved */
/* Slot 13 is reserved */
/* Slot 14 is reserved */
/* Slot 15 is reserved */
/* Slot 16 is reserved */
/* Slot 17 is reserved */
/* Slot 18 is reserved */
/* Slot 19 is reserved */
/* Slot 20 is reserved */
/* Slot 21 is reserved */
/* Slot 22 is reserved */
/* Slot 23 is reserved */
/* Slot 24 is reserved */
/* Slot 25 is reserved */
/* Slot 26 is reserved */
/* Slot 27 is reserved */
/* Slot 28 is reserved */
/* Slot 29 is reserved */
/* 30 */
TKIMGAPI int		tkimg_GetDistanceValue(Tcl_Interp *interp,
				const char *string, double *doublePtr);
/* 31 */
TKIMGAPI int		tkimg_SetResolution(Tcl_Obj *metadataDict,
				double xdpi, double ydpi);
/* 32 */
TKIMGAPI int		tkimg_GetResolution(Tcl_Interp *interp,
				Tcl_Obj *metadataDict, double *xdpi,
				double *ydpi);
/* 33 */
TKIMGAPI int		tkimg_SetNumPages(Tcl_Obj *metadataDict,
				int numImages);
/* 34 */
TKIMGAPI int		tkimg_GetNumPages(Tcl_Interp *interp,
				Tcl_Obj *metadataDict, int *numImages);
/* 35 */
TKIMGAPI int		tkimg_ListObjGetElements(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Tcl_Size *argc,
				Tcl_Obj ***argv);
/* Slot 36 is reserved */
/* Slot 37 is reserved */
/* Slot 38 is reserved */
/* Slot 39 is reserved */
/* Slot 40 is reserved */
/* Slot 41 is reserved */
/* Slot 42 is reserved */
/* Slot 43 is reserved */
/* Slot 44 is reserved */
/* Slot 45 is reserved */
/* Slot 46 is reserved */
/* Slot 47 is reserved */
/* Slot 48 is reserved */
/* Slot 49 is reserved */
/* 50 */
TKIMGAPI int		tkimg_IsIntel(void);
/* 51 */
TKIMGAPI void		tkimg_CreateGammaTable(double gammaVal,
				double *gammaTable);
/* 52 */
TKIMGAPI double		tkimg_LookupGammaTable(double val,
				const double *gammaTable);
/* 53 */
TKIMGAPI void		tkimg_UShortToUByte(int n,
				const unsigned short *shortIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 54 */
TKIMGAPI void		tkimg_ShortToUByte(int n, const short *shortIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 55 */
TKIMGAPI void		tkimg_FloatToUByte(int n, const float *floatIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 56 */
TKIMGAPI int		tkimg_ReadUByteRow(tkimg_Stream *handle,
				unsigned char *pixels, int nBytes);
/* 57 */
TKIMGAPI int		tkimg_ReadUShortRow(tkimg_Stream *handle,
				unsigned short *pixels, int nShorts,
				char *buf, int swapBytes);
/* 58 */
TKIMGAPI int		tkimg_ReadShortRow(tkimg_Stream *handle,
				short *pixels, int nShorts, char *buf,
				int swapBytes);
/* 59 */
TKIMGAPI int		tkimg_ReadFloatRow(tkimg_Stream *handle,
				float *pixels, int nFloats, char *buf,
				int swapBytes);
/* 60 */
TKIMGAPI int		tkimg_ReadUByteFile(tkimg_Stream *handle,
				unsigned char *buf, int width, int height,
				int nchan, int verbose, int findMinMax,
				double *minVals, double *maxVals);
/* 61 */
TKIMGAPI int		tkimg_ReadUShortFile(tkimg_Stream *handle,
				unsigned short *buf, int width, int height,
				int nchan, int swapBytes, int verbose,
				int findMinMax, double *minVals,
				double *maxVals, double saturation);
/* 62 */
TKIMGAPI int		tkimg_ReadFloatFile(tkimg_Stream *handle, float *buf,
				int width, int height, int nchan,
				int swapBytes, int verbose, int findMinMax,
				double *minVals, double *maxVals,
				double saturation);
/* 63 */
TKIMGAPI void		tkimg_RemapUShortValues(unsigned short *buf,
				int width, int height, int nchan,
				double *minVals, double *maxVals,
				double agcCutOffPercent, int printAgc);
/* 64 */
TKIMGAPI void		tkimg_RemapFloatValues(float *buf, int width,
				int height, int nchan, double *minVals,
				double *maxVals, double agcCutOffPercent,
				int printAgc);
/* 65 */
TKIMGAPI void		tkimg_UIntToUByte(int n, const unsigned int *intIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 66 */
TKIMGAPI void		tkimg_IntToUByte(int n, const int *intIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 67 */
TKIMGAPI int		tkimg_ReadUIntRow(tkimg_Stream *handle,
				unsigned int *pixels, int nInts, char *buf,
				int swapBytes);
/* 68 */
TKIMGAPI int		tkimg_ReadIntRow(tkimg_Stream *handle, int *pixels,
				int nInts, char *buf, int swapBytes);
/* 69 */
TKIMGAPI int		tkimg_ReadUIntFile(tkimg_Stream *handle,
				unsigned int *buf, int width, int height,
				int nchan, int swapBytes, int verbose,
				int findMinMax, double *minVals,
				double *maxVals, double saturation);
/* 70 */
TKIMGAPI void		tkimg_RemapUIntValues(unsigned int *buf, int width,
				int height, int nchan, double *minVals,
				double *maxVals, double agcCutOffPercent,
				int printAgc);
/* 71 */
TKIMGAPI void		tkimg_DoubleToUByte(int n, const double *doubleIn,
				const double *gammaTable,
				unsigned char *ubOut);
/* 72 */
TKIMGAPI int		tkimg_ReadDoubleRow(tkimg_Stream *handle,
				double *pixels, int nDoubles, char *buf,
				int swapBytes);
/* 73 */
TKIMGAPI int		tkimg_ReadDoubleFile(tkimg_Stream *handle,
				double *buf, int width, int height,
				int nchan, int swapBytes, int verbose,
				int findMinMax, double *minVals,
				double *maxVals, double saturation);
/* 74 */
TKIMGAPI void		tkimg_RemapDoubleValues(double *buf, int width,
				int height, int nchan, double *minVals,
				double *maxVals, double agcCutOffPercent,
				int printAgc);

typedef struct TkimgStubs {
    int magic;
    const struct TkimgStubHooks *hooks;

    Tcl_Channel (*tkimg_OpenFileChannelPtr) (Tcl_Interp *interp, const char *fileName, const char *mode); /* 0 */
    void (*tkimg_ReadInitFilePtr) (tkimg_Stream *handle, Tcl_Channel chan); /* 1 */
    int (*tkimg_ReadInitStringPtr) (tkimg_Stream *handle, Tcl_Obj *data); /* 2 */
    void (*tkimg_WriteInitFilePtr) (tkimg_Stream *handle, Tcl_Channel chan); /* 3 */
    void (*tkimg_WriteInitStringPtr) (tkimg_Stream *handle); /* 4 */
    void (*tkimg_EnableReadBufferPtr) (tkimg_Stream *handle, int onOff); /* 5 */
    Tcl_Size (*tkimg_ReadPtr) (tkimg_Stream *handle, char *dst, Tcl_Size count); /* 6 */
    Tcl_Size (*tkimg_WritePtr) (tkimg_Stream *handle, const char *src, Tcl_Size count); /* 7 */
    int (*tkimg_PutcPtr) (tkimg_Stream *handle, int c); /* 8 */
    void (*tkimg_GetTemporaryFileNamePtr) (Tcl_DString *fileName); /* 9 */
    void (*tkimg_DeleteFilePtr) (const char *fileName); /* 10 */
    void (*reserved11)(void);
    void (*reserved12)(void);
    void (*reserved13)(void);
    void (*reserved14)(void);
    void (*reserved15)(void);
    void (*reserved16)(void);
    void (*reserved17)(void);
    void (*reserved18)(void);
    void (*reserved19)(void);
    void (*reserved20)(void);
    void (*reserved21)(void);
    void (*reserved22)(void);
    void (*reserved23)(void);
    void (*reserved24)(void);
    void (*reserved25)(void);
    void (*reserved26)(void);
    void (*reserved27)(void);
    void (*reserved28)(void);
    void (*reserved29)(void);
    int (*tkimg_GetDistanceValuePtr) (Tcl_Interp *interp, const char *string, double *doublePtr); /* 30 */
    int (*tkimg_SetResolutionPtr) (Tcl_Obj *metadataDict, double xdpi, double ydpi); /* 31 */
    int (*tkimg_GetResolutionPtr) (Tcl_Interp *interp, Tcl_Obj *metadataDict, double *xdpi, double *ydpi); /* 32 */
    int (*tkimg_SetNumPagesPtr) (Tcl_Obj *metadataDict, int numImages); /* 33 */
    int (*tkimg_GetNumPagesPtr) (Tcl_Interp *interp, Tcl_Obj *metadataDict, int *numImages); /* 34 */
    int (*tkimg_ListObjGetElementsPtr) (Tcl_Interp *interp, Tcl_Obj *objPtr, Tcl_Size *argc, Tcl_Obj ***argv); /* 35 */
    void (*reserved36)(void);
    void (*reserved37)(void);
    void (*reserved38)(void);
    void (*reserved39)(void);
    void (*reserved40)(void);
    void (*reserved41)(void);
    void (*reserved42)(void);
    void (*reserved43)(void);
    void (*reserved44)(void);
    void (*reserved45)(void);
    void (*reserved46)(void);
    void (*reserved47)(void);
    void (*reserved48)(void);
    void (*reserved49)(void);
    int (*tkimg_IsIntelPtr) (void); /* 50 */
    void (*tkimg_CreateGammaTablePtr) (double gammaVal, double *gammaTable); /* 51 */
    double (*tkimg_LookupGammaTablePtr) (double val, const double *gammaTable); /* 52 */
    void (*tkimg_UShortToUBytePtr) (int n, const unsigned short *shortIn, const double *gammaTable, unsigned char *ubOut); /* 53 */
    void (*tkimg_ShortToUBytePtr) (int n, const short *shortIn, const double *gammaTable, unsigned char *ubOut); /* 54 */
    void (*tkimg_FloatToUBytePtr) (int n, const float *floatIn, const double *gammaTable, unsigned char *ubOut); /* 55 */
    int (*tkimg_ReadUByteRowPtr) (tkimg_Stream *handle, unsigned char *pixels, int nBytes); /* 56 */
    int (*tkimg_ReadUShortRowPtr) (tkimg_Stream *handle, unsigned short *pixels, int nShorts, char *buf, int swapBytes); /* 57 */
    int (*tkimg_ReadShortRowPtr) (tkimg_Stream *handle, short *pixels, int nShorts, char *buf, int swapBytes); /* 58 */
    int (*tkimg_ReadFloatRowPtr) (tkimg_Stream *handle, float *pixels, int nFloats, char *buf, int swapBytes); /* 59 */
    int (*tkimg_ReadUByteFilePtr) (tkimg_Stream *handle, unsigned char *buf, int width, int height, int nchan, int verbose, int findMinMax, double *minVals, double *maxVals); /* 60 */
    int (*tkimg_ReadUShortFilePtr) (tkimg_Stream *handle, unsigned short *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 61 */
    int (*tkimg_ReadFloatFilePtr) (tkimg_Stream *handle, float *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 62 */
    void (*tkimg_RemapUShortValuesPtr) (unsigned short *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 63 */
    void (*tkimg_RemapFloatValuesPtr) (float *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 64 */
    void (*tkimg_UIntToUBytePtr) (int n, const unsigned int *intIn, const double *gammaTable, unsigned char *ubOut); /* 65 */
    void (*tkimg_IntToUBytePtr) (int n, const int *intIn, const double *gammaTable, unsigned char *ubOut); /* 66 */
    int (*tkimg_ReadUIntRowPtr) (tkimg_Stream *handle, unsigned int *pixels, int nInts, char *buf, int swapBytes); /* 67 */
    int (*tkimg_ReadIntRowPtr) (tkimg_Stream *handle, int *pixels, int nInts, char *buf, int swapBytes); /* 68 */
    int (*tkimg_ReadUIntFilePtr) (tkimg_Stream *handle, unsigned int *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 69 */
    void (*tkimg_RemapUIntValuesPtr) (unsigned int *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 70 */
    void (*tkimg_DoubleToUBytePtr) (int n, const double *doubleIn, const double *gammaTable, unsigned char *ubOut); /* 71 */
    int (*tkimg_ReadDoubleRowPtr) (tkimg_Stream *handle, double *pixels, int nDoubles, char *buf, int swapBytes); /* 72 */
    int (*tkimg_ReadDoubleFilePtr) (tkimg_Stream *handle, double *buf, int width, int height, int nchan, int swapBytes, int verbose, int findMinMax, double *minVals, double *maxVals, double saturation); /* 73 */
    void (*tkimg_RemapDoubleValuesPtr) (double *buf, int width, int height, int nchan, double *minVals, double *maxVals, double agcCutOffPercent, int printAgc); /* 74 */
} TkimgStubs;

#ifdef __cplusplus
extern "C" {
#endif
TKIMGAPI const TkimgStubs *tkimgStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_TKIMG_STUBS)

/*
 * Inline function declarations:
 */

#define tkimg_OpenFileChannel \
	(tkimgStubsPtr->tkimg_OpenFileChannelPtr) /* 0 */
#define tkimg_ReadInitFile \
	(tkimgStubsPtr->tkimg_ReadInitFilePtr) /* 1 */
#define tkimg_ReadInitString \
	(tkimgStubsPtr->tkimg_ReadInitStringPtr) /* 2 */
#define tkimg_WriteInitFile \
	(tkimgStubsPtr->tkimg_WriteInitFilePtr) /* 3 */
#define tkimg_WriteInitString \
	(tkimgStubsPtr->tkimg_WriteInitStringPtr) /* 4 */
#define tkimg_EnableReadBuffer \
	(tkimgStubsPtr->tkimg_EnableReadBufferPtr) /* 5 */
#define tkimg_Read \
	(tkimgStubsPtr->tkimg_ReadPtr) /* 6 */
#define tkimg_Write \
	(tkimgStubsPtr->tkimg_WritePtr) /* 7 */
#define tkimg_Putc \
	(tkimgStubsPtr->tkimg_PutcPtr) /* 8 */
#define tkimg_GetTemporaryFileName \
	(tkimgStubsPtr->tkimg_GetTemporaryFileNamePtr) /* 9 */
#define tkimg_DeleteFile \
	(tkimgStubsPtr->tkimg_DeleteFilePtr) /* 10 */
/* Slot 11 is reserved */
/* Slot 12 is reserved */
/* Slot 13 is reserved */
/* Slot 14 is reserved */
/* Slot 15 is reserved */
/* Slot 16 is reserved */
/* Slot 17 is reserved */
/* Slot 18 is reserved */
/* Slot 19 is reserved */
/* Slot 20 is reserved */
/* Slot 21 is reserved */
/* Slot 22 is reserved */
/* Slot 23 is reserved */
/* Slot 24 is reserved */
/* Slot 25 is reserved */
/* Slot 26 is reserved */
/* Slot 27 is reserved */
/* Slot 28 is reserved */
/* Slot 29 is reserved */
#define tkimg_GetDistanceValue \
	(tkimgStubsPtr->tkimg_GetDistanceValuePtr) /* 30 */
#define tkimg_SetResolution \
	(tkimgStubsPtr->tkimg_SetResolutionPtr) /* 31 */
#define tkimg_GetResolution \
	(tkimgStubsPtr->tkimg_GetResolutionPtr) /* 32 */
#define tkimg_SetNumPages \
	(tkimgStubsPtr->tkimg_SetNumPagesPtr) /* 33 */
#define tkimg_GetNumPages \
	(tkimgStubsPtr->tkimg_GetNumPagesPtr) /* 34 */
#define tkimg_ListObjGetElements \
	(tkimgStubsPtr->tkimg_ListObjGetElementsPtr) /* 35 */
/* Slot 36 is reserved */
/* Slot 37 is reserved */
/* Slot 38 is reserved */
/* Slot 39 is reserved */
/* Slot 40 is reserved */
/* Slot 41 is reserved */
/* Slot 42 is reserved */
/* Slot 43 is reserved */
/* Slot 44 is reserved */
/* Slot 45 is reserved */
/* Slot 46 is reserved */
/* Slot 47 is reserved */
/* Slot 48 is reserved */
/* Slot 49 is reserved */
#define tkimg_IsIntel \
	(tkimgStubsPtr->tkimg_IsIntelPtr) /* 50 */
#define tkimg_CreateGammaTable \
	(tkimgStubsPtr->tkimg_CreateGammaTablePtr) /* 51 */
#define tkimg_LookupGammaTable \
	(tkimgStubsPtr->tkimg_LookupGammaTablePtr) /* 52 */
#define tkimg_UShortToUByte \
	(tkimgStubsPtr->tkimg_UShortToUBytePtr) /* 53 */
#define tkimg_ShortToUByte \
	(tkimgStubsPtr->tkimg_ShortToUBytePtr) /* 54 */
#define tkimg_FloatToUByte \
	(tkimgStubsPtr->tkimg_FloatToUBytePtr) /* 55 */
#define tkimg_ReadUByteRow \
	(tkimgStubsPtr->tkimg_ReadUByteRowPtr) /* 56 */
#define tkimg_ReadUShortRow \
	(tkimgStubsPtr->tkimg_ReadUShortRowPtr) /* 57 */
#define tkimg_ReadShortRow \
	(tkimgStubsPtr->tkimg_ReadShortRowPtr) /* 58 */
#define tkimg_ReadFloatRow \
	(tkimgStubsPtr->tkimg_ReadFloatRowPtr) /* 59 */
#define tkimg_ReadUByteFile \
	(tkimgStubsPtr->tkimg_ReadUByteFilePtr) /* 60 */
#define tkimg_ReadUShortFile \
	(tkimgStubsPtr->tkimg_ReadUShortFilePtr) /* 61 */
#define tkimg_ReadFloatFile \
	(tkimgStubsPtr->tkimg_ReadFloatFilePtr) /* 62 */
#define tkimg_RemapUShortValues \
	(tkimgStubsPtr->tkimg_RemapUShortValuesPtr) /* 63 */
#define tkimg_RemapFloatValues \
	(tkimgStubsPtr->tkimg_RemapFloatValuesPtr) /* 64 */
#define tkimg_UIntToUByte \
	(tkimgStubsPtr->tkimg_UIntToUBytePtr) /* 65 */
#define tkimg_IntToUByte \
	(tkimgStubsPtr->tkimg_IntToUBytePtr) /* 66 */
#define tkimg_ReadUIntRow \
	(tkimgStubsPtr->tkimg_ReadUIntRowPtr) /* 67 */
#define tkimg_ReadIntRow \
	(tkimgStubsPtr->tkimg_ReadIntRowPtr) /* 68 */
#define tkimg_ReadUIntFile \
	(tkimgStubsPtr->tkimg_ReadUIntFilePtr) /* 69 */
#define tkimg_RemapUIntValues \
	(tkimgStubsPtr->tkimg_RemapUIntValuesPtr) /* 70 */
#define tkimg_DoubleToUByte \
	(tkimgStubsPtr->tkimg_DoubleToUBytePtr) /* 71 */
#define tkimg_ReadDoubleRow \
	(tkimgStubsPtr->tkimg_ReadDoubleRowPtr) /* 72 */
#define tkimg_ReadDoubleFile \
	(tkimgStubsPtr->tkimg_ReadDoubleFilePtr) /* 73 */
#define tkimg_RemapDoubleValues \
	(tkimgStubsPtr->tkimg_RemapDoubleValuesPtr) /* 74 */

#endif /* defined(USE_TKIMG_STUBS) */

/* !END!: Do not edit above this line. */

#undef TCL_STORAGE_CLASS
#define TCL_STORAGE_CLASS DLLIMPORT

#endif /* _TKIMGDECLS */
